\version "2.18.0"
\language "deutsch"

\paper {
 %#(set-paper-size "a4")
  markup-system-spacing = #'((basic-distance . 2))
  %system-system-spacing = #'((basic-distance . 1))
  %system-system-spacing #'basic-distance = #1
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 10\mm
  ragged-last-bottom=##f
  %system-count = #6
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Cinei Tale"
  subtitle = "glas 7"
  composer =  "N. Moldoveanu"
  meter = "Andante"
  tagline=""
}

global = {
  \key c \major
  %\cadenzaOn
  \autoBeamOff
  \time 4/4
  %\override Staff.TimeSignature #'stencil = ##f
  \partial 2
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  Ci -- nei Ta -- le ce -- lei de tai -- nă,
  as -- tăzi, __ Fi -- ul lui Dum -- ne -- zeu,
  păr -- taş __ mă pri -- meş -- te, __ că nu voi __ spu -- ne 
  tai -- na Ta vrăj -- ma -- şi -- lor Tăi,
  nici să -- ru -- ta -- re Îţi voi da ca Iu -- da;
  ci ca tâl -- ha -- rul, măr -- tu -- ri -- sin -- du -- mă,
  strig Ţi -- e: po -- me -- neş -- te -- mă, 
  Doam -- ne, când vei ve -- ni în -- tru Îm -- pă -- ră -- ţi -- a __ Ta. __ 
}

bassWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 
  nici să -- ru -- ta -- re Îţi voi da ca Iu -- da;

}

sopMusic = \relative c'' {
  d4^\mp c h8([ c] d4) d2 e8([ d] c4) d8([ e]) f4 e( d) 
  c2 f^\< e4( f\!) g( a8[ g]) f4 e^\> d c\! d4. d8 a([ h] c4) 
  h8([ a]) g4 a8([ h] c4) c2( \time 2/4 c4) \breathe c \time 4/4 e d8([ e]) c([ h]) a4 
  h c d e f( g) f^\< e d4. g8 f4\! e 
  a( g f e^\>) d2 c4\! h a g a8([ h] c4) c4. c8 
  \time 2/4 h4 c \time 4/4 d( e) d4. c8 \time 2/4 d4^\< e \time 4/4 f d e\! f 
  g( a8[ g^\>] f4 e\!) d2 d4^\mf^\< e f(\! g^\>) f8([ e]) d4\! 
  e8([ d e f]) d4. c8^\p d4 e f e d c h a 
  h^\markup "rall." ( c) d( e) \acciaccatura e8 d4( c2.) \fermata
  \bar "|."
}

altMusic = \relative c'' {
  d4 c h8([ c] h4) h2 c8([ h] c4) h8([ c]) d4 c( h) c2
  c2 c e4( f8[ e]) d4 c h c h4. h8 a([ h] a4) h8([ a]) g4
  a8([ g] a4) g2( g4) g c h8([ c]) g4 a g a h c d( e) d c
  h4. e8 d4 c c( cis d c) d2 c4 h a g f8([ g] a4) g4. c8 
  h4 c h( c) h4. c8 h4 c d h c d e( f8[ e] d4 c) h2
  h4 c d( e) d8([ c]) h4 c8([ h c d]) h4. c8
  h4 c d c h a g a g( a) h( c) h( g2.)
  
}

tenorMusic = \relative c' {
  d4 c h8([ a] g4) g2 g2 g4 g g2 c a2 g4( a) c2 h4 c
  g4 a g4. g8 a([ g] f4) g8([ f]) e4 f8([ e] d4) e2( e4) 
  e g g e f g g g g g2 g4 g g2( g4.) g8
  a4 a a2 a2 a4 g \time 2/4 f e \time 4/4 d( f) e4. c'8
  h4 a g2 g4. g8 \time 2/4 g4 g \time 4/4 g g g g c2( h4 c)
  g2 g4 g g( c) g4 g g2 g4. a8 g4 g g g g d e f g2 g f4( e2.)
  
}

bassMusic = \relative c' {
  d4 c h8([ a] g4) g2 g2 g4 g g2 c f,2 c4( f) c'2 g4 g
  g4 a g4. g8 a([ g] f4) g8([ f]) e4 f8([ e] d4) c2( c4)
  c c g c8([ e]) f4 g g g g g2 g4 g g2( g4.) g8
  f4 e d( a) d2 d4 e f e d( c) c4. c'8
  h4 a g2 g4. g8 g4 g g g g g c2( h4 c) g2 g4 g
  g2 g4 g g2 g4. a8 g4 g g g g d e f g2 g, g4( c2.)
  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \global \voiceOne \sopMusic }
      \new Voice { \global \voiceTwo \altMusic }
      \addlyrics { \sopWords }
    >>
        
    \new Staff <<
      \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      \new Voice { \global \voiceTwo \bassMusic }
      \addlyrics { \bassWords }
      %\new Lyrics \lyricsto "split" { a -- şa, a -- şa şi pre pă -- mânt. }
     
    >>
    >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}


\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
